// Borland C++ Builder
// Copyright (c) 1995, 2005 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'Inipwatch.pas' rev: 10.00

#ifndef InipwatchHPP
#define InipwatchHPP

#pragma delphiheader begin
#pragma option push
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member functions
#pragma pack(push,8)
#include <System.hpp>	// Pascal unit
#include <Sysinit.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Incomponent.hpp>	// Pascal unit
#include <Inthread.hpp>	// Pascal unit
#include <Inbasecomponent.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Inipwatch
{
//-- type declarations -------------------------------------------------------
class DELPHICLASS TInIPWatchThread;
class PASCALIMPLEMENTATION TInIPWatchThread : public Inthread::TInThread 
{
	typedef Inthread::TInThread inherited;
	
protected:
	int FInterval;
	System::TObject* FSender;
	Classes::TNotifyEvent FTimerEvent;
	virtual void __fastcall Run(void);
	void __fastcall TimerEvent(void);
public:
	#pragma option push -w-inl
	/* TInThread.Create */ inline __fastcall virtual TInIPWatchThread(bool ACreateSuspended, bool ALoop, AnsiString AName) : Inthread::TInThread(ACreateSuspended, ALoop, AName) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TInThread.Destroy */ inline __fastcall virtual ~TInIPWatchThread(void) { }
	#pragma option pop
	
};


class DELPHICLASS TInIPWatch;
class PASCALIMPLEMENTATION TInIPWatch : public Incomponent::TInComponent 
{
	typedef Incomponent::TInComponent inherited;
	
protected:
	bool FActive;
	AnsiString FCurrentIP;
	bool FHistoryEnabled;
	AnsiString FHistoryFilename;
	Classes::TStringList* FIPHistoryList;
	bool FIsOnline;
	bool FLocalIPHuntBusy;
	int FMaxHistoryEntries;
	int FOnLineCount;
	Classes::TNotifyEvent FOnStatusChanged;
	AnsiString FPreviousIP;
	TInIPWatchThread* FThread;
	unsigned FWatchInterval;
	void __fastcall AddToIPHistoryList(AnsiString Value);
	void __fastcall CheckStatus(System::TObject* Sender);
	void __fastcall SetActive(bool Value);
	void __fastcall SetMaxHistoryEntries(int Value);
	void __fastcall SetWatchInterval(unsigned Value);
	virtual void __fastcall InitComponent(void);
	
public:
	__fastcall virtual ~TInIPWatch(void);
	bool __fastcall ForceCheck(void);
	void __fastcall LoadHistory(void);
	AnsiString __fastcall LocalIP();
	void __fastcall SaveHistory(void);
	__property AnsiString CurrentIP = {read=FCurrentIP};
	__property Classes::TStringList* IPHistoryList = {read=FIPHistoryList};
	__property bool IsOnline = {read=FIsOnline, nodefault};
	__property AnsiString PreviousIP = {read=FPreviousIP};
	
__published:
	__property bool Active = {read=FActive, write=SetActive, nodefault};
	__property bool HistoryEnabled = {read=FHistoryEnabled, write=FHistoryEnabled, default=1};
	__property AnsiString HistoryFilename = {read=FHistoryFilename, write=FHistoryFilename};
	__property int MaxHistoryEntries = {read=FMaxHistoryEntries, write=SetMaxHistoryEntries, default=25};
	__property Classes::TNotifyEvent OnStatusChanged = {read=FOnStatusChanged, write=FOnStatusChanged};
	__property unsigned WatchInterval = {read=FWatchInterval, write=SetWatchInterval, default=1000};
public:
	#pragma option push -w-inl
	/* TInBaseComponent.Create */ inline __fastcall TInIPWatch(Classes::TComponent* AOwner)/* overload */ : Incomponent::TInComponent(AOwner) { }
	#pragma option pop
	
};


//-- var, const, procedure ---------------------------------------------------
static const Shortint IP_WATCH_HIST_MAX = 0x19;
#define IP_WATCH_HIST_FILENAME "iphist.dat"
static const Word IP_WATCH_INTERVAL = 0x3e8;

}	/* namespace Inipwatch */
using namespace Inipwatch;
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// Inipwatch
